'Lithium-Ion Conditioner by Dan Amos
'Licenses under Attribution-NonCommercial-ShareAlike 3.0 Australia license
' http://creativecommons.org/licenses/by-nc-sa/3.0/au/
  
Dim win(55,8) 'up to 43 windows with these attributes:
'0 - left
'1 - top
'2 - width
'3 - height
'4 - parent window. 0 means no parent (eg dialog)
'5 - type: 0 = dialog, 1 = button, 3 = edit, 4 = static
'6 - value: 0 = normal, 1 = down, 2 = red, 3 = green, 4 = blue
'7 - function code

Dim wintext$(55) 'text associated with window

Dim termCurrent = 0.06 'current in A when charging will stop
Dim disVoltage = 3.6  'voltage below which discharging will stop
Dim maxChargeTime = 86400000 'maximum charging time in ms: 1 day
Dim maxDischargeTime = 43200000 ' maximum discharge time in ms: 12h
Dim dischargeRes = 8.2 'actual value of discharge resistor

Dim foreCol%, bkCol%, radCol%, alCol%, tempCol%, btnCol, btnSel
Dim cell
Dim mode '0:off, 1:charge cell, 2: discharge cell, 3: charge all, 4:disch all
Dim cv = 0 'cell voltage
Dim cc = 0 'cell current
Dim vcal = 1.471 'voltage calibration
Dim volts(154), curr(154)
Dim rac(10) 'rolling average current
Dim mah = 0
Dim modeTimer%, lastTime%

start:
  initialize
  l = 0
  l2 = 0
  Do
    CheckTouch
    Pause 5
    l = l + 1
    If l > 100 Then
      l = 0
      If mode < 5 Then CheckVoltage
      Select Case mode
      Case 0
        l2 = l2 + 1
        If l2 > 10 Then
          l2 = 0
          cell = cell + 1
          If cell > 4 Then cell = 1
          selectcell cell
        EndIf
      Case 1
        DoCharge
      Case 3
        DoCharge
      Case 2
        DoDischarge
      Case 4
        DoDischarge
      End Select
    EndIf
  Loop 

Sub DoCharge
  If cc < termCurrent Or Timer - modetimer% > maxchargetime Then
    If mode = 1 Then
      setmode 0
      Pin(10)=0
    Else
      cell = cell + 1
      If cell > 4 Then
        cell = 1
        setmode 0
        selectcell cell
        Pin(10) = 0
      Else
        selectcell cell
        modetimer% = Timer
      EndIf
    EndIf
  EndIf
End Sub

Sub DoDischarge
  mah = mah + (Timer - lasTime%) / 3600000 * cv / dischargeRes
  lastTimer% = Timer
  If cv < disVoltage Or Timer - modetimer% > maxdischargetime Then
    If mode = 2 Then
      wintext$(b1 + cell - 1) = Str$(mah,0,0) + "mAh"
      setmode 5
      selectcell cell
      Pin(10)=0
    Else
      wintext$(b1 + cell - 1) = Str$(mah,0,0) + "mAh"
      mah = 0
      cell = cell + 1
      If cell > 4 Then
        cell = 1
        setmode 5
        selectcell cell
        Pin(10) = 0
      Else
        selectcell cell
        modetimer% = Timer
      EndIf
    EndIf
  EndIf
End Sub

Sub initialize
  CLS
  numwindows = 0
  winMain = createwindow(0,0,320,240,0,0,0," ") 
  b1 = createWindow(3,2,77,50,winMain,1,100,"0.00V")
  b2 = createWindow(83,2,77,50,winMain,1,101,"0.00V")
  b3 = createWindow(163,2,77,50,winMain,1,102,"0.00V")
  b4 = createWindow(242,2,77,50,winMain,1,103,"0.00V")
  bChCell = createWindow(1,56,100,42,winMain,1,104,"Charge Cell")
  bDisCell = createWindow(1,100,100,42,winMain,1,105,"Disch Cell")
  bChAll = createWindow(1,150,100,42,winMain,1,106,"Charge All")
  bDisAll = createWindow(1,194,100,42,winMain,1,107,"Disch All")

  foreCol% = RGB(white)
  bkCol% = RGB(0,80,116)
  btnCol = 170
  btnSel = 230
  win(b1,6) = 4
  cell = 1
  mode = 0
  DrawWindow winMain, bkCol%
  DrawGraph
  SetPin 26,ain 'isense from reg
  SetPin 24,ain 'voltage of current cell
  SetPin 9,dout 'charge=1, discharge=0
  SetPin 10,dout 'isolate=0, connect = 1
  SetPin 16,dout 'top cell = 0, other = 1
  SetPin 17,dout '2nd cell = 0, other = 1
  SetPin 18,dout '3rd cell = 0, 4th = 1
  For i = 0 To 152
    volts(i) = 209
    curr(i) = 209
  Next i
End Sub

Function CreateWindow(lft, top, width, height, parent, type, funct, windowtext$)
  numwindows = numwindows + 1
  win(numwindows,0) = lft
  win(numwindows,1) = top
  win(numwindows,2) = width
  win(numwindows,3) = height
  win(numwindows,4) = parent
  win(numwindows,5) = type
  win(numwindows,6) = 0
  win(numwindows,7) = funct
  wintext$(numwindows) = windowtext$
  createwindow = numwindows
End Function

Sub DrawWindow id, clr
  'draws window and child windows. If clr is 1, background is cleared
  If win(id,4) <> 0 Then Exit Sub
  Font #1,1
  If clr<>0 Then CLS bkcol%
  activewindow = id
  'draw children
  For i = 1 To numwindows
    If win(i,4) = id Then
      If win(i,5) = 1 Then
        DrawButton(i)
      ElseIf win(i,5) = 3 Then
        DrawEdit(i, 1)
      ElseIf win(i,5) = 4 Then
        DrawStatic(i)
    ElseIf win(i,5) = 5 Then
    DrawLevel(i)
      EndIf
    EndIf
  Next i
End Sub

Sub DrawButton b
  Local c = btnCol
  Local cr = btnSel
  col = RGB(c,c,c)
  If win(b,6) = 2 Then 'red
    col = RGB(cr,0,0)
  ElseIf win(b,6) = 3 Then 'green
    col = RGB(0,cr,0)
  ElseIf win(b,6) = 4 Then 'blue
    col = RGB(0,0,cr)
  EndIf
  RBox win(b,0),win(b,1),win(b,2),win(b,3),2,col,col
  Text win(b,0) + win(b,2) / 2, win(b,1) + win(b,3) / 2, wintext$(b), CM,1,1, foreCol%,col
End Sub

Sub CheckTouch
  x = Touch(x)
  y = Touch(y)
  For i = 2 To numwindows
   If (x >= win(i,0) And x <= win(i,0) + win(i,2) And y >= win(i,1) And y <= win(i,1) + win(i,3)) Then
     ButtonHit(i)
     Exit Sub
   EndIf
  Next i
End Sub

Sub ButtonHit btn
  If Timer - dbTimer% < 200 Then Exit Sub
  dbTimer% = Timer
  Local b = win(btn,7)
  Select Case b
  Case 100
    If mode = 5 Then checkvoltages
    setmode 0
    selectcell 1
    Pin(9)=0
    Pin(10)=0
  Case 101
    If mode = 5 Then checkvoltages
    setmode 0
    selectcell 2
    Pin(9)=0
    Pin(10)=0
  Case 102
    If mode = 5 Then checkvoltages
    setmode 0
    selectcell 3
    Pin(9)=0
    Pin(10)=0
  Case 103
    If mode = 5 Then checkvoltages
    setmode 0
    selectcell 4
    Pin(9)=0
    Pin(10)=0
  Case 104
    setmode 1
    selectcell cell
    ChargeCell
  Case 105
    setmode 2
    selectcell cell
    DischargeCell
  Case 106
    setmode 3
    cell = 1
    selectcell cell
    chargecell
  Case 107
    setmode 4
    cell = 1
    selectcell cell
    dischargecell
  Case Else
  'default handler
  End Select

End Sub

Sub DrawGraph
  For i = 0 To 153: volts(i) = 0: curr(i) = 0: Next i
  RBox 105, 55, 228, 180,2,RGB(white),RGB(white)
  Line 135,67,135,210,1,RGB(blue)
  Text 133,67,"4.2",RT,1,1,RGB(blue),RGB(white)
  Text 133,99,"4.0",RT,1,1,RGB(blue),RGB(white)
  Text 133,131,"3.8",RT,1,1,RGB(blue),RGB(white)
  Text 133,163,"3.6",RT,1,1,RGB(blue),RGB(white)
  Text 133,197,"3.4",RT,1,1,RGB(blue),RGB(white)
  Line 290,67,290,210,1,RGB(magenta)
  Text 293,67,"0.8","LT",1,1,RGB(magenta),RGB(white)
  Text 293,99,"0.6","LT",1,1,RGB(magenta),RGB(white)
  Text 293,131,"0.4","LT",1,1,RGB(magenta),RGB(white)
  Text 293,163,"0.2","LT",1,1,RGB(magenta),RGB(white)
  Text 293,197,"0.0","LT",1,1,RGB(magenta),RGB(white)
  Line 135,210,290,210,1,RGB(black)
  Text 135,213,"-150s",LT,1,1,RGB(black),RGB(white)
  Text 290,213,"Now",RT,1,1,RGB(black),RGB(white)
End Sub

Sub SelectCell c
  cell = c
  Local v = 0
  If mode > 2 Then v = 4
  win(b1,6)=v
  win(b2,6)=v
  win(b3,6)=v
  win(b4,6)=v
  v = 4
  If mode = 1 Or mode = 3 Then v = 3
  If mode = 2 Or mode = 4 Then v = 2
  win(b1 + cell - 1,6) = v
  drawbutton b1
  drawbutton b2
  drawbutton b3
  drawbutton b4
  If cell = 1 Then
    Pin(16)=0
    Pin(17)=0
    Pin(18)=0
  Else
    Pin(16)=1
    If cell = 2 Then
      Pin(17)=0
      Pin(18)=0
    Else
      Pin(17)=1
      If cell = 3 Then
        Pin(18)=0
      Else
        Pin(18)=1
      EndIf
    EndIf
  EndIf
End Sub

Sub ChargeCell
DrawGraph
Pin(9)=0
Pin(10)=1
End Sub

Sub DischargeCell
drawgraph
Pin(9)=1
Pin(10)=1
lastTime% = Timer
End Sub

Sub setmode m
  mode = m
  win(bChCell,6)=0
  win(bDisCell,6)=0
  win(bChAll,6)=0
  win(bDisAll,6)=0
  If mode > 0 Then win(bChCell + m -1,6)=4
  drawbutton bChCell
  drawbutton bDisCell
  drawbutton bChAll
  drawbutton bDisAll
  For i = 0 To 9: rac(i)=0.1: Next i
  modetimer% = Timer
End Sub

Sub CheckVoltage
cv = Pin(24) * vcal
Local c = (Pin(26) * vcal - cv) * 10
cc = 0
For i = 0 To 9
  cc = cc + rac(i)
  If i < 9 Then
    rac(i) = rac(i + 1)
  Else
    rac(i) = c
  EndIf
Next i
cc = cc / 10
Select Case mode
  Case 0
    cc = 0
  Case 2
    cc = cv / dischargeRes
  Case 4
    cc = cv / dischargeRes
End Select
If mode = 2 Or mode = 4 Then
  If mah < 1000 Then
    wintext$(b1 + cell - 1) = Str$(mah,0,0) + "mAh"
  Else
    wintext$(b1 + cell - 1) = Str$(mah / 1000, 0,2) + "Ah"
  EndIf
Else
  wintext$(b1 + cell - 1) = Str$(cv,0,2)
EndIf
drawbutton b1 + cell - 1
plotvoltage
End Sub

Sub plotvoltage
volts(153) = 209 - (cv - 3.4) * 177
If volts(153) < 67 Then volts(153) = 67
If volts(153) > 209 Then volts(153) = 209
curr(153) = 209 - cc * 177
If curr(153) < 67 Then curr(153) = 67
If curr(153) > 209 Then curr(153) = 209
For i = 0 To 152
  If volts(i) > 66 Then
    Pixel 136 + i,volts(i),RGB(white)
    Pixel 136 + i,volts(i)-1,RGB(white)
    volts(i) = volts(i + 1)
    Pixel 136 + i,volts(i),RGB(blue)
    Pixel 136 +i,volts(i)-1,RGB(blue)
  Else
    volts(i) = volts(i+1)
  EndIf
  If curr(i) > 66 Then
    Pixel 136 + i,curr(i),RGB(white)
    Pixel 136 + i,curr(i)-1,RGB(white)
    curr(i) = curr(i + 1)
    Pixel 136 + i,curr(i),RGB(magenta)
    Pixel 136 + i,curr(i)-1,RGB(magenta)
  Else
    curr(i) = curr(i+1)
  EndIf
Next i
End Sub

Sub CheckVoltages
Pin(10)=0
For cell = 1 To 4
  selectcell cell
  Pause 200
  checkvoltage
Next cell
End Sub
